#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Random procedural textures 3Mod01.fsh by Jarble
//https://www.shadertoy.com/view/WlVBWm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


//----------------------------------------------------------------------------------------
//  3 out, 1 in...
vec3 hash31(float p)
{
    //from David Hoskin's "Hash without sine"
   vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
   p3 += dot(p3, p3.yzx+33.33);
   return fract((p3.xxy+p3.yzz)*p3.zyx); 
}

//----------------------------------------------------------------------------------------
///  3 out, 3 in...
vec3 hash33(vec3 p3)
{
	p3 = fract(p3 * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yxz+33.33);
    return fract((p3.xxy + p3.yxx)*p3.zyx);

}

vec2 fract1(vec2 a,vec2 random,float scale1){
    return (abs(fract(a*scale1+100.0*random)-.5));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor = vec4(0.0);
    vec3 col;
    float t;
    float t2=iTime/20.0;
    float t3 = 8.0;
    for(int c=0;c<3;c++){
	    vec2 uv = (fragCoord*5.0-iResolution.xy)/iResolution.y/10.0*t3;
        uv += vec2(iTime/2.0,iTime/3.0)/8.0*t3;
        float scale = 3.0;
        
        
        //vec3 random = vec3(sin(t2/13.0),sin(t2/17.0),sin(t2/19.0))/2.0+.5;
        vec3 random = hash31(floor((iTime+uv.x)/5.0))*2.0;
        float scale1 = .5+(random.z)/2.0;
        //random.xy = random.z;
        //vec3 random = hash31(10.0);
        scale = scale1 * 1.5;
        
        for(int i=0;i<3;i++)
        {
            
            random = (hash33(random)+vec3(.5))*2.0;
            //scale1 *= 1.+random.z/1.7/2.0;
            uv.y /= -scale1;
            //uv=fract(uv.yx+(uv)/scale);
            uv=fract(uv/scale1+uv.yx/scale);

            uv = fract1(uv/scale1,random.yx,scale1)*scale1;
            uv /= scale;
            uv=uv.yx+col.yx;
            uv.y *= -scale+uv.y;
            col = col.yzx;
        }
     col[c] = fract((uv.x)-(uv.y));
	}
    
    fragColor = vec4(vec3(col),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

